﻿using System;
using System.Runtime.Serialization;

namespace VIMT.VideoVisit.Messages
{
    [DataContract]
    public class VIMTTmpPatients
    {

        [DataMember]
        public VIMTTmpPersonIdentifier Id { get; set; }

        [DataMember]
        public VIMTTmpPersonName Name { get; set; }

        [DataMember]
        public VIMTTmpContactInformation ContactInformation { get; set; }

        [DataMember]
        public VIMTTmpLocation Location { get; set; }

        [DataMember]
        public VIMTTmpVirtualMeetingRoom VirtualMeetingRoom { get; set; }

        [DataMember]
        public bool VistaDateTimeSpecified { get; set; }

        [DataMember]
        public DateTime VistaDateTime { get; set; }
    }

    [DataContract]
    public class VIMTTmpPersonIdentifier
    {
        [DataMember]
        public string AssigningAuthority { get; set; }

        [DataMember]
        public string UniqueId { get; set; }
    }

    [DataContract]
    public class VIMTTmpProviders
    {
        [DataMember]
        public VIMTTmpPersonName Name { get; set; }

        [DataMember]
        public VIMTTmpPersonIdentifier Id { get; set; }

        [DataMember]
        public VIMTTmpContactInformation ContactInformation { get; set; }

        [DataMember]
        public VIMTTmpVirtualMeetingRoom VirtualMeetingRoom { get; set; }

        [DataMember]
        public VIMTTmpLocation Location { get; set; }

        [DataMember]
        public bool VistaDateTimeSpecified { get; set; }

        [DataMember]
        public DateTime VistaDateTime { get; set; }
    }

    [DataContract]
    public class VIMTTmpPersonName
    {
        [DataMember]
        public string FirstName { get; set; }

        [DataMember]
        public string LastName { get; set; }

        [DataMember]
        public string MiddleInitial { get; set; }
    }

    [DataContract]
    public class VIMTTmpContactInformation
    {
        [DataMember]
        public string Mobile { get; set; }

        [DataMember]
        public string PreferredEmail { get; set; }

        [DataMember]
        public string AlternativeEmail { get; set; }

        [DataMember]
        public int TimeZone { get; set; }

        [DataMember]
        public bool TimeZoneSpecified { get; set; }
    }

    [DataContract]
    public class VIMTTmpVirtualMeetingRoom
    {
        [DataMember]
        public string Conference { get; set; }

        [DataMember]
        public string Pin { get; set; }

        [DataMember]
        public string Url { get; set; }
    }

    [DataContract]
    public class VIMTTmpLocation
    {
        [DataMember]
        public VIMTTmpLocationType Type { get; set; }

        [DataMember]
        public VIMTTmpFacility Facility { get; set; }

        [DataMember]
        public VIMTTmpClinic Clinic { get; set; }
    }

    [DataContract]
    public class VIMTTmpFacility
    {
        [DataMember]
        public string Name { get; set; }

        [DataMember]
        public string SiteCode { get; set; }

        [DataMember]
        public int TimeZone { get; set; }
    }

    [DataContract]
    public class VIMTTmpClinic
    {
        [DataMember]
        public string Ien { get; set; }

        [DataMember]
        public string Name { get; set; }
    }

    [DataContract]
    public class VIMTTmpStatus
    {
        [DataMember]
        public string Description { get; set; }

        [DataMember]
        public VIMTTmpStatusCode Code { get; set; }

        [DataMember]
        public bool CodeSpecified { get; set; }

        [DataMember]
        public VIMTTmpReasonCode Reason { get; set; }

        [DataMember]
        public bool ReasonSpecified { get; set; }
    }

    public enum VIMTTmpStatusCode
    {
        CHECKED_IN,
        CHECKED_OUT,
        NO_ACTION_TAKEN,
        NO_SHOW,
        CANCELLED_BY_CLINIC,
        NO_SHOW_AND_AUTO_RE_BOOK,
        CANCELLED_BY_CLINIC_AND_AUTO_RE_BOOK,
        INPATIENT_APPOINTMENT,
        CANCELLED_BY_PATIENT,
        CANCELLED_BY_PATIENT_AND_AUTO_REBOOK,
        FUTURE,
        NON_COUNT,
        DELETED,
        ACTION_REQUIRED
    }

    public enum VIMTTmpReasonCode
    {
        APPOINTMENT_NO_LONGER_REQUIRED,
        CLINIC_CANCELLED,
        CLINIC_STAFFING,
        DEATH_IN_FAMILY,
        INPATIENT_STATUS,
        OTHER,
        PATIENT_DEATH,
        PATIENT_NOT_ELIGIBLE,
        SCHEDULING_CONFLICT_OR_ERROR,
        TRANSFER_OPT_CARE_TO_OTHER_VA,
        TRAVEL_DIFFICULTY,
        UNABLE_TO_KEEP_APPOINTMENT,
        WEATHER
    }

    [DataContract]
    public class VIMTTmpWriteResults
    {
        [DataMember]
        public VIMTTmpWriteResult[] VIMTTmpWriteResult { get; set; }
    }

    [DataContract]
    public class VIMTTmpWriteResult
    {
        [DataMember]
        public string PersonId { get; set; }

        [DataMember]
        public VIMTTmpPersonName Name { get; set; }

        [DataMember]
        public string FacilityCode { get; set; }

        [DataMember]
        public string FacilityName { get; set; }

        [DataMember]
        public string ClinicIen { get; set; }

        [DataMember]
        public string ClinicName { get; set; }

        [DataMember]
        public DateTime DateTime { get; set; }

        [DataMember]
        public VIMTTmpVistaStatus VistaStatus { get; set; }

        [DataMember]
        public string Reason { get; set; }
    }

    public enum VIMTTmpVistaStatus
    {
        BOOKED,
        FAILED_TO_BOOK,
        RECEIVED,
        FAILED_TO_RECEIVE,
        CANCELLED,
        FAILED_TO_CANCEL
    }

    public enum VIMTTmpSchedulingRequestType
    {
        NEXT_AVAILABLE_APPT,
        OTHER_THAN_NEXT_AVAILABLE_CLINICIAN_REQUESTED,
        OTHER_THAN_NEXT_AVAILABLE_PATIENT_REQUESTED,
        WALKIN_APPTOINTMENT,
        MULTIPLE_APPTOINTMENT_BOOKING,
        AUTO_REBOOK,
        OTHER_THAN_NEXT_AVAILABLE_APPOINTMENT
    }

    public enum VIMTTmpAppointmentType
    {
        COMPENSATION_AND_PENSION,
        CLASS_II_DENTAL,
        ORGAN_DONORS,
        EMPLOYEE,
        PRIMA_FACIA,
        RESEARCH,
        COLLATERAL_OF_VET,
        SHARING_AGREEMENT,
        REGULAR,
        COMPUTER_GENERATED,
        SERVICE_CONNECTED
    }

    public enum VIMTTmpAppointmentKind
    {
        CLINIC_BASED,
        STORE_FORWARD,
        MOBILE_ANY,
        MOBILE_GFE,
        ADHOC
    }

    public enum VIMTTmpLocationType
    {
        VA,
        NonVA
    }
}